import type { ApplyOptInOptions } from "../apply/optIn.js";
import type { Service, ServiceGroup } from "../types/service.js";

/**
 * This event is fired when the user has consent and services are executed (but in `document.readyState === "interactive"` state).
 *
 * For non-interactive state use the `opt-in` and `opt-out` events.
 */
export const APPLY_INTERACTIVE_EVENT = "RCB/Apply/Interactive";

export type ApplyInteractiveEvent<ServiceAdditional = unknown> = {
    /**
     * Accepted services.
     */
    services: Array<{
        group: ServiceGroup;
        service: Service & ServiceAdditional;
    }>;
} & Pick<ApplyOptInOptions, "triggeredByOtherTab">;
