import type { Service, ServiceGroup } from "../types/service.js";

export const OPT_IN_ALL_EVENT = "RCB/OptIn/All";

export type OptInAllEvent<ServiceAdditional = object> = {
    services: Array<{
        group: ServiceGroup;
        service: Service & ServiceAdditional;
    }>;
    /**
     * This promise determines if all the opt-in scripts are loaded and fully available.
     */
    ready: Promise<[void[], void[]]>;
};
