import type { Service, ServiceGroup } from "../types/service.js";

export const OPT_OUT_ALL_EVENT = "RCB/OptOut/All";

export type OptOutAllEvent<ServiceAdditional = any> = {
    services: Array<{
        group: ServiceGroup;
        // TODO: should we rename this to `service`?
        service: Service & ServiceAdditional;
    }>;
    /**
     * List of service IDs which hold HTTP cookies and need to be deleted server-side.
     */
    deleteHttpCookies: number[];
    /**
     * This promise determines if all the opt-in and opt-out scripts are loaded and fully available.
     */
    ready: Promise<[[void[], void[]], void[]]>;
};
