import type { PreDecisionGatewayResult } from "../predecision/gateway.js";

export const PREDECISION_GATEWAY_EVENT_PROMISES = "RCB/PreDecision/Promises";

/**
 * Dynamically allow to get a predecision with a extra request to external promises from a custom `document` event.
 * You are allowed to add multiple promises but the first resolved one which resolves a predecision
 * gets respected. If a promise returns a non-valid predecision (e.g. `void`) it is ignored (useful
 * to delay the appearance of the cookie banner programmatically).
 *
 * ### Example: Delay the cookie banner by 15 seconds
 *
 * ```js
 * document.addEventListener("RCB/PreDecision/Promises", ({ detail: { promises } }) => {
 *   promises.push(new Promise((resolve) => setTimeout(resolve, 15000)));
 * });
 * ```
 *
 * ### Example: Do not show a cookie banner but only allow essential services
 *
 * ```js
 * document.addEventListener("RCB/PreDecision/Promises", ({ detail: { promises } }) => {
 *   promises.push(Promise.resolve("essentials"));
 * });
 * ```
 */
export type PreDecisionGatewayEventPromises = {
    promises: Array<Promise<PreDecisionGatewayResult | void>>;
};
