import type { Service } from "../types/service.js";

function findUsedGcmConsentTypes(services: Service[]) {
    return [
        ...new Set(
            services
                .map(({ googleConsentModeConsentTypes }) =>
                    // Create copy when it comes as `ObservableArray` (mobx)
                    [...googleConsentModeConsentTypes],
                )
                .flat(),
        ),
    ];
}

export { findUsedGcmConsentTypes };
