import { yieldMainThread } from "@devowl-wp/react-utils";

import { isCrawler } from "../utils/isCrawler.js";

import type { PreDecisionGateway, PreDecisionGatewayResult } from "./gateway.js";

/**
 * Is the current request from a spider / crawler?
 */
const preDecisionGatewayIsCrawler: (resultIfBot: false | PreDecisionGatewayResult) => PreDecisionGateway =
    (resultIfBot) =>
    async ({ getUserDecision }) => {
        await yieldMainThread();
        if (getUserDecision() !== false || !resultIfBot) {
            return false;
        }

        return isCrawler() ? resultIfBot : false;
    };

export { preDecisionGatewayIsCrawler };
