import { supportsCookies } from "../utils/supportsCookies.js";

import type { PreDecisionGateway } from "./gateway.js";

/**
 * Does the current browser support cookies?
 */
const preDecisionGatewaySupportsCookies: PreDecisionGateway = async ({ supportsCookiesName }) => {
    return supportsCookies(supportsCookiesName) ? false : "essentials";
};

export { preDecisionGatewaySupportsCookies };
