import type { PreDecisionGateway } from "./gateway.js";

/**
 * Has the user already consent to the latest requested revision (hash)?
 */
const preDecisionGatewayUserConsent: PreDecisionGateway = async ({ revisionHash, getUserDecision }) => {
    const decision = getUserDecision();
    if (decision === false) {
        return false;
    }

    const { revision } = decision;
    return revisionHash === revision ? "consent" : false;
};

export { preDecisionGatewayUserConsent };
