import type { CookieConsentManagerOptions } from "../apply/manager.js";
import type { TcfMetadata } from "../types/tcf.js";
import type { TCModel } from "@iabtechlabtcf/core";

/**
 * Apply our meta data fields to the `TCModel`.
 *
 * @see https://www.npmjs.com/package/@iabtechlabtcf/core#user-content-cmp-meta-fields
 */
function applyTcfModelMetadata(
    model: TCModel,
    tcfMetadata: TcfMetadata,
    { cmpId, cmpVersion }: Pick<CookieConsentManagerOptions, "cmpId" | "cmpVersion">,
) {
    model.cmpId = cmpId;
    model.isServiceSpecific = tcfMetadata.scope === "service-specific";

    model.cmpVersion = cmpVersion;
    // model.consentLanguage = tcfMetadata["language"].toUpperCase(); (see https://git.io/Jmjqs)
}

export { applyTcfModelMetadata };
