import type { IServiceTemplateClientResponse } from "@devowl-wp/api-real-cookie-banner";

type ServiceTagManager =
    | "none"
    /**
     * @deprecated Use `googleTagManagerWithGcm` instead.
     */
    | "googleTagManager"
    | "googleTagManagerWithGcm"
    | "matomoTagManager";

// TODO: reuse type of `IServiceTemplateTechnicalDefinition`
type ServiceTechnicalDefinition = {
    type: "http" | "local" | "session" | "flash" | "indexedDb";
    name: string;
    host: string;
    duration?: number;
    durationUnit?: "s" | "m" | "h" | "d" | "mo" | "y";
    isSessionDuration?: boolean;
};

type Service = Pick<
    IServiceTemplateClientResponse,
    | "legalBasis"
    | "isEmbeddingOnlyExternalResources"
    | "tagManagerOptInEventName"
    | "tagManagerOptOutEventName"
    | "executePriority"
    | "codeOptIn"
    | "codeOptOut"
    | "codeOnPageLoad"
    | "executeCodeOptInWhenNoTagManagerConsentIsGiven"
    | "executeCodeOptOutWhenNoTagManagerConsentIsGiven"
    | "deleteTechnicalDefinitionsAfterOptOut"
    | "googleConsentModeConsentTypes"
> & {
    id: number;
    /**
     * E.g. `gtm` will be used for the Google Tag Manager integration (special cases).
     */
    presetId?: string;
    uniqueName: string;
    technicalDefinitions: ServiceTechnicalDefinition[];
    codeDynamics: Record<string, string>;
};

type ServiceGroup = {
    id: number;
    slug: string;
    isEssential: boolean;
    items: Service[];
};

export { type ServiceTagManager, type ServiceTechnicalDefinition, type Service, type ServiceGroup };
