import type {
    EServiceTemplateDataProcessingInCountriesSpecialTreatment,
    ITcfGvlAdditionalInformation,
    ITcfGvlDeviceStorageDisclosure,
} from "@devowl-wp/api-real-cookie-banner";

import type { Declarations, VendorList } from "@iabtechlabtcf/core";

// TODO: should we import the types from `backends/real-cookie-banner-backend/src/types/service/tcf.ts`?

type TcfScope = "service-specific" | "global";

type TcfDeclarationFilter = "consent" | "legInt";

type TcfGvlDeviceStorageDisclosure = ITcfGvlDeviceStorageDisclosure;

type TcfGvlAdditionalInformation = ITcfGvlAdditionalInformation;

type TcfMetadata = {
    gvlSpecificationVersion: VendorList["gvlSpecificationVersion"];
    tcfPolicyVersion: VendorList["tcfPolicyVersion"];
    publisherCc: string;
    vendorListVersion: VendorList["vendorListVersion"];
    scope: TcfScope;
    language: string;
};

type TcfVendorConfigurationRestrictivePurposes = Record<
    "normal", // currently only purposes (not special purposes) can be disabled, but keep it in a map in case of TCF adds another type of purposes
    Record<string, { enabled: true; legInt?: "yes" | "no" }>
>;

type TcfVendorConfigurationMeta = {
    vendorId: number;
    restrictivePurposes: TcfVendorConfigurationRestrictivePurposes;
    dataProcessingInCountries: string[];
    dataProcessingInCountriesSpecialTreatments: EServiceTemplateDataProcessingInCountriesSpecialTreatment[];
};

type Tcf = Omit<VendorList, keyof TcfMetadata | "lastUpdated"> & {
    vendorConfigurations: Record<string, TcfVendorConfigurationMeta>;
    unused: Omit<Declarations, "stacks">;
};

export {
    type TcfScope,
    type TcfDeclarationFilter,
    type TcfGvlDeviceStorageDisclosure,
    type TcfGvlAdditionalInformation,
    type TcfMetadata,
    type TcfVendorConfigurationRestrictivePurposes,
    type TcfVendorConfigurationMeta,
    type Tcf,
};
