/**
 * Let a `Promise` be rejected after a given amount of time.
 */
function promiseTimeout<PromiseValue>(promise: Promise<PromiseValue>, ms: number): Promise<PromiseValue> {
    return new Promise((resolve, reject) => {
        promise.then(resolve, reject);

        const e = new Error("Timed out");
        setTimeout(reject, ms, e);
    });
}

export { promiseTimeout };
