# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## 1.2.3 (2026-01-23)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.15</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* validate container registry image did not catch curl errors correctly (CU-86931jwau)</details>





## 1.2.2 (2026-01-20)


### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


### Maintenance

* upgrade dependencies (CU-86931jwau)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.16</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Dependency updates @devowl-wp/resolve-none-computed-style 1.1.51</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.13</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* only scan current branch with gitleaks (CU-869aw6tca)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* use complyforce.com as production domain (CU-8699th190)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.21</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade dependencies (CU-86931jwau)
* upgrade to Node 24 (CU-86931jwau)
* use Relation type for ESM preparation in TypeORM relations (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.22</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.15</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/playwright-utils 1.0.33</summary>


**_Purpose of dependency:_** _Provide Playwright test utilities for monorepo docker applications including a smoke test runner._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.47</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.52</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>





## 1.2.1 (2026-01-15)


### Bug Fixes

* in some cases content does not get unblocked when scripts without loading-semantics need to be unblocked first (CU-869brj1eb)


### Code Refactoring

* consent handling to use a transport object for better flexibility and add support for 'or' condition in consent checks (CU-f535x6)


### Maintenance

* code AI review (note 7026, CU-f535x6)


<details><summary>Development dependency update @devowl-wp/playwright-utils 1.0.32</summary>


**_Purpose of dependency:_** _Provide Playwright test utilities for monorepo docker applications including a smoke test runner._
##### Maintenance

* remove package.json#engines from internal packages (CU-86931jwau)</details>





# 1.2.0 (2025-12-10)


### Bug Fixes

* introduce new client-side: content blocker rule syntax (CU-f535x6)
* prevent iframe location replacement on Firefox Mobile to avoid App-Intent dialog (CU-869be8n2w)


### Features

* add support for script modules in content blocker (CU-869be7jn7)
* block dynamically injected scripts and stylesheets until consent (CU-f535x6)







## 1.1.21 (2025-12-02)


### Bug Fixes

* visual confirm.content blocker is shown a second time on click (CU-869b2p070)


### Performance Improvements

* fix high LCP when using a lot of visual content blockers with confirm() syntax (CU-869b2p070)


### Tests

* better code coverage with c8 (node-executed code) and v8 (client-side executed code) (CU-f535x6)


<details><summary>Development dependency update @devowl-wp/playwright-utils 1.0.31</summary>


**_Purpose of dependency:_** _Provide Playwright test utilities for monorepo docker applications including a smoke test runner._
##### Tests

* better code coverage with c8 (node-executed code) and v8 (client-side executed code) (CU-f535x6)</details>





## 1.1.20 (2025-11-21)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.12</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* introduce secret-scanner with gitleaks (CU-869aw6tca)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.20</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>





## 1.1.19 (2025-10-15)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/ts-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>





## 1.1.18 (2025-09-24)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.10</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* oss-extract only in master pipeline (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.19</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.19</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>





## 1.1.17 (2025-09-04)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.9</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* introduce Complyforce API backend (CU-8699tdjp0)


##### Continuous Integration

* pnpm-lock.yaml should be considered as common file change (CU-869a875re)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.18</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* switch from node fetch to undici request and make it work with streams and content encoding (CU-86997627z)</details>





## 1.1.16 (2025-07-29)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* resource group for Docker Review deployments to avoid race condition in Swarm subnet allocation (CU-8699xj5ue)


##### Tests

* introduce optional playwright coverage with c8 (CU-8699761na)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.17</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* compatibility with latest version of Taskfile (CU-8699761na)</details>





## 1.1.15 (2025-07-10)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* allow to recreate the gitlab-ci image manually (CU-8696heugb)
* docker review should not rely on manual containerize job (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.17</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* vitest/prefer-expect-resolves (CU-8698r80f9)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* stabilize scrolling and stats with timer (CU-8696heugb)</details>





## 1.1.14 (2025-06-25)


### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.9</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Dependency updates @devowl-wp/resolve-none-computed-style 1.1.44</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* only release clouflare worker when changes are made (CU-869954ppf)


##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.16</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.15</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* make the headless content url scanner work in ESM and CJS (CU-8696heugb)


##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)</details>





## 1.1.13 (2025-06-11)


### Bug Fixes

* compatibility with lazy loaded Google Maps in Voxel theme (CU-86998q97k)







## 1.1.12 (2025-05-15)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)


##### Continuous Integration

* deploy Cloudflare workers in master and develop environment (CU-8698nqyb0)
* make Cloudflare worker builds available in review apps through own docker image packaged with Wrangler (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.15</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>





## 1.1.11 (2025-05-13)


### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Dependency updates @devowl-wp/resolve-none-computed-style 1.1.42</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* move internal apps to our monorepo codebase and introduce swarm (CU-31mn75v)
* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.14</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* use first mounted container (CU-8694v2pwc)


##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.14</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>





## 1.1.10 (2025-05-06)


### Bug Fixes

* compatibility with Vimeo embeds in Breakdance builder (CU-8698w84ub)







## 1.1.9 (2025-04-25)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.3</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* use GIT_STRATEGY none to fetch the commit in review stop job (CU-8698fyv1c)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.13</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* quill editor and WYSIWYG editors are not rendered (CU-8698tv43q)</details>





## 1.1.8 (2025-04-14)


### Bug Fixes

* a deduplicated visual content blocker for Elementor videos autoplays all videos after unblock (CU-8698pajgj)







## 1.1.7 (2025-04-08)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* create owlreview.de certificates instead of swarm.owlreview.de (CU-8697hja46)
* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.4</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>





## 1.1.6 (2025-03-27)


### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Dependency updates @devowl-wp/resolve-none-computed-style 1.1.39</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


##### Continuous Integration

* create wildcard certificate for owlsrv.de (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.12</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.10</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.3</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>





## 1.1.5 (2025-03-19)


### Bug Fixes

* compatibility with Elementor widget CSS and cut visual content blocker headline (CU-8698c7t2b)







## 1.1.4 (2025-03-04)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.3</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* show a notice when a template is machine translated (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* build docker containers only after the install job (CU-8697hja46)
* generate production certificates for devowl.io and owlinfra.de (CU-8697hja46)
* generate production Lets Encrypt certificates instead of staging server (CU-8697hja46)


##### Features

* run develop pipeline which creates review app certificates on new branch (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.11</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* implement transaction handling in email and storage operations, update ESLint rules for ORM CUD methods (CU-861mfub3j)</details>





## 1.1.3 (2025-02-25)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* create checksum over all certificates (CU-8697hja46)
* generate certificates for swarm revie apps (CU-8697hja46)
* generate regularily certificates with go-acme/lego for our CI runners (CU-8697hja46)
* generate regularily wildcard certificates with go-acme/lego for our CI runners (CU-8697hja46)
* remove orphan certificates (CU-8697hja46)
* use home-runner for WordPress.org push (CU-86980hdd8)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.1</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* generate certificates for swarm revie apps (CU-8697hja46)</details>





## 1.1.2 (2025-02-24)


### Bug Fixes

* compatibility with presto-player (CU-8697zc5r2)







## 1.1.1 (2025-02-20)


### Bug Fixes

* correctly block lazy custom web elements by using window.consentApi.unblock API (CU-8697zc5r2)
* make ratio- a ratio CSS class to set the correct height of a blocked element







# 1.1.0 (2025-02-06)


### Bug Fixes

* compatibility with Elementors optimized markup experimental feature (CU-8697pxjtc)


### Features

* introduce new selector syntax function jQueryHijackFn to hijack jQuery functions (CU-8697ptyry)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* always validate docker images when built (CU-8696heugb)


##### Build System

* streamline docker and setup.sh into a Taskfile.setup.yml (CU-8696k3cct)


##### Continuous Integration

* always validate and try to fix docker images (CU-8697pj0tx)
* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Tests

* make static files inclusive domain mapping available in playwright tests and create first test (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.0</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Features

* new command merge-request-tree (also as VSCode task) to visually show Merge Requests (CU-8692xtha4)</details>





## 1.0.1 (2025-01-14)


### Bug Fixes

* delegate click to unblocked nodes after all resources are loaded (CU-gt22gk)







# 1.0.0 (2024-11-07)


### Maintenance

* initial release (CU-869656drt)


### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.0</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>





## 0.8.16 (2024-10-23)


### Bug Fixes

* compatibility with Presto Player not rendering all video embeds (CU-86960tuve)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)


##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.10</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.16</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)</details>





## 0.8.15 (2024-09-26)


### Bug Fixes

* compatibility with Divi video slider and visual content blockers (CU-8695kgg74)
* do not stop execution when a hijacked jQuery function runs into an error (CU-8695hkk9h)


### Performance Improvements

* force to render visual content blockers for :confirm() dialogs in idle step (CU-8695xjmf6)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* provide APP_NAME and APP_VERSION in backend environment (CU-8695emete)
* restore production database dump app-versionized (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.5</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* make public changelog generation work again with latest Taskfile version (CU-8695kgrpr)


##### Maintenance

* update retypeapp (CU-8695kgrpr)</details>





## 0.8.14 (2024-08-28)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* performance tuning and shouldUpdate tweaks (CU-861n9jg7k)</details>





## 0.8.13 (2024-08-01)


### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.6</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>





## 0.8.12 (2024-07-16)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.







## 0.8.11 (2024-06-20)


### Bug Fixes

* allow to use confirm() together with visualParent() (CU-2w37t6q)


### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Dependency updates @devowl-wp/resolve-none-computed-style 1.1.33</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.8</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.4</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* remove npm-update-checker CLI command as we use Renovate now (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>





## 0.8.10 (2024-05-29)


### Bug Fixes

* allow to delegateClick() the real element before opening the hero dialog (confirm(), CU-m15mty)
* do not render visual content blockers in nested confirm() blockers (CU-m15mty)







## 0.8.9 (2024-04-09)


### Bug Fixes

* window.onload assignment should behave like window load event (CU-86947my22)







## 0.8.8 (2024-03-13)


### Bug Fixes

* allow to avoid visual content blocker deduplication through custom class rcb-avoid-deduplication on parent element (CU-86940a5nt)
* compatibility with GoodLayers page builder and unblocking background videos (CU-8693wxcad)







## 0.8.7 (2024-02-26)


### Bug Fixes

* compatibility with Kadence video popups (CU-8693jtbzu)
* initiators for load event should wait also for async scripts (CU-8693wju7t)


### Performance

* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.2</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* cookie banner cannot be accepted on old Safari browsers (CU-8693u1wzm)


##### Performance

* do no longer use webpackMode eager in favor of inline-require (CU-8693n1cc5)
* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)
* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* render shortcodes async and add lazy-require() webpack plugin (CU-8693cqz75)


##### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Performance

* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.7</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Performance

* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)</details>





## 0.8.6 (2024-01-25)


### Bug Fixes

* compatibility with Flatsome UX builder and visual content blockers for video embeds (CU-8693jdhgk)


### Maintenance

* update to antd@5 (CU-863gku332)


<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.6</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.11</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* use project ID to read associated merge request for pipeline (CU-apv5uu)</details>





## 0.8.5 (2024-01-18)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* output ci summary for review application URLs for traefik v2 (CU-2rjtd0)


##### Continuous Integration

* automatically retry to fetch the git repository three times when there is a temporary error (CU-8693j5ngt)
* deploy backends in production to docker-host-6.owlsrv.de (CU-2rjtd0)


##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.0</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>





## 0.8.4 (2024-01-08)


### Bug Fixes

* awin ad within a link is not correctly unblocked, only on reload (CU-8693ff6kr)







## 0.8.3 (2023-12-22)


### Bug Fixes

* adsbygoogle.push() error: Fluid responsive ads must be at least 250px wide (CU-8693cxm1p)







## 0.8.2 (2023-12-21)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* correctly check for the SHA of the latest master branch (CU-8693bzjkb)


##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.5</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>





## 0.8.1 (2023-12-19)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* rotate transaction_ids_by_target_id every 14 days (CU-86937dv6w)
* upload did not work with newer Debian version, disable StrictHostKeyChecking for lftp upload (CU-86937dw3d)


##### Features

* allow to skip publish of packages by regular expression in merge request description with target branch master (CU-8693bzjkb)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* show skipped publish packages as those in the generated CHANGELOG.md files (CU-8693bzjkb)</details>





# 0.8.0 (2023-12-15)


### Features

* allow to set required purposes for TCF content blockers (CU-86933edy3)







## 0.7.7 (2023-11-28)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)


##### Testing

* introduce @devowl-wp/playwright-utils with smoke test functionality (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.4</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.9</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* update Gitlab YAML typings (CU-8692yek74)</details>





## 0.7.6 (2023-11-24)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* show inconsistent translations always in translation status (CU-86932cagc)
* validate production docker compose config on compose YAML changes (CU-86934wg6z)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* also delete skipped pipelines and pipelines of deleted branches</details>





## 0.7.5 (2023-10-27)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.7</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* purge master pipelines after 90 days instead of 360</details>





## 0.7.4 (2023-10-12)


### Bug Fixes

* do not deduplicate content blocker for confirm selector syntax function (CU-866axjayz)


### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)


<details><summary>Dependency updates @devowl-wp/resolve-none-computed-style 1.1.23</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.3</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.9</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* include changelogs from dependencies (CU-2k54tcb)


##### Maintenance

* major update commander (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* major update commander (CU-3cj43t)
* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>





## 0.7.3 (2023-09-29)


### docs

* remove not understandable commit messages from changelog (CU-861n7an31)


### perf

* improve Content Blocker how it affects PageSpeed Insights (CU-866axeb2m)





## 0.7.2 (2023-09-06)


### fix

* use correct width of blocked iframe (CU-866avthxz)





## 0.7.1 (2023-08-28)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.7.0 (2023-08-24)


### feat

* accessible content blocker (CU-863h2xzc9)
* allow renaming attribute when an element matches a selector (CU-861n6p9uq)
* allow to add a custom checker when hijacking jQuery.fn functions (CU-861n86a5n)
* introduce new confirm() selector-syntax rule for content blockers (CU-861n86a5n)


### fix

* detect visual responsive video container also from padding-bototm attribute (CU-861n6p9uq)


### refactor

* introduce class names and a scoped stylesheet to Cookie Banner instead of style attribute (CU-2yt81xz)


### style

* make visual content blocker always opacity:1 (CU-861n86a5n)





## 0.6.9 (2023-08-02)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.6.8 (2023-07-06)


### fix

* window.onload not working without whitespace before the assignment (window.onload=, CU-861mzcqw0)





## 0.6.7 (2023-05-30)


### fix

* correctly decode base64 encoded string when unblocking inline CSS (CU-861mvm5np)





## 0.6.6 (2023-05-22)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.6.5 (2023-05-21)


### chore

* remove dotenv package (CU-861m6e3mz)





## 0.6.4 (2023-05-15)


### fix

* hijack jQuery functions when they got lazy loaded through e.g. WP Rocket (CU-863gqwb7q)
* iframe is not loading src when copied through innerHTML as src URL is not persisted to DOM (CU-863gmpgq4)





## 0.6.3 (2023-05-11)


### fix

* back button in Firefox does not work as expected when unblocking iframe (CU-863gmpgq4)





## 0.6.2 (2023-04-24)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.6.1 (2023-04-19)


### refactor

* introduce taskfile.dev Taskfiles (CU-85zrrymj0)





# 0.6.0 (2023-03-24)


### feat

* introduce new selector syntax function jQueryHijackEach (CU-863gac0ng)





## 0.5.3 (2023-03-21)


### chore

* update dependencies including TypeScript 4.9, antd and eslint (CU-85zrqk9pd)





## 0.5.2 (2023-03-14)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.5.1 (2023-02-15)


### fix

* new selector syntax function to delegate a click on blocked node (CU-863g124r8)





# 0.5.0 (2023-01-25)


### feat

* new selector syntax functions forceVisual() and visualParent() (CU-33z67qt)


### fix

* allow window DOMContentLoaded to be listened on blocked scripts (CU-861m7cb9u)
* compatibility with Breakdance page builder and YouTube embeds (CU-33z67qt)
* do not transform host URLs to URLs (CU-863fx90bn)
* jQuery hijacking function with jQuery(document).myFn() support (CU-861m901up)





## 0.4.8 (2023-01-10)


### fix

* gutenberg YouTube block content blocker not rendered when using within TwentyTwenty theme (CU-861m6whn6)





## 0.4.7 (2022-12-22)


### chore

* update all package.json to resolve release conflicts (CU-382p4kb)





## 0.4.6 (2022-12-12)


### fix

* make jQuery fn hijacking work with async scripts (CU-37q2mng)





## 0.4.5 (2022-12-01)


### fix

* improved compatibility with Oxygen youtube embeds (CU-34g8wne)





## 0.4.4 (2022-11-24)


### fix

* compatibility with Uncode fluid objects not rendering visual content blockers (CU-344p8r3)
* improved compatibility with Elementor Pro and lazy loaded scripts (CU-33z3dh8)
* sometimes visual content blockers did not unblock after page reload when deferred scripts loading too long (CU-33ternv)
* visual content blocker deduplication for Elementor embeds (CU-344x343)
* when content blocker got deduplicated it auto plays more than one video (CU-344x343)
* wrapFn compatibility with content unblocking initiators like jQuery (CU-33ternv)





## 0.4.3 (2022-11-18)


### fix

* white space above videos with Avada embed (CU-33ta42n)


### perf

* reduce time to interactive by rendering visual content blockers earlier (CU-33ternv)





## 0.4.2 (2022-11-09)


### fix

* pass non blocked elements in hijacked jQuery functions as array instead of single elements (CU-332gq49)


### style

* white space above visual content blocker when parent has padding top aspect ratio (CU-32wqa34)





## 0.4.1 (2022-10-31)


### fix

* jQuery function hijacking now works with multiple elements (CU-32h4gp0)


### style

* white space below blocked Oxygen YouTube video (CU-32bhcnj)





# 0.4.0 (2022-10-25)


### feat

* allow to define a consent-click-dispatch-resize attribute to dispatch resize event after click (CU-3204cj6)





## 0.3.5 (2022-10-11)


### chore

* introduce consistent type checking for all TypeScript files (CU-2eap113)
* prepare script management for self-hosted Gitlab migrations (CU-2yt2948)
* put gitlab.com URL into environment variables to prepare for self hosted instance (CU-2yt2948)
* remove unused dependencies (CU-3rmk7b)


### fix

* compatibility with HivePress and memoize jQuery events with their parameters (CU-30xxbyt)
* compatibility with Neuron themes and their advanced google maps Elementor widget (CU-313bduc)
* compatibility with OnePress maps and jQuery.each hijacking (CU-30cg9tv)





## 0.3.4 (2022-09-16)


### fix

* allow nested native event listeners in blocked scripts (CU-2yypzau)





## 0.3.3 (2022-09-06)


### fix

* compatibility with blocked content and white box in fancybox (CU-2x5j0cy)
* compatibility with Divi video embed, thumbnail overlays and autoplay (CU-2vxpf7d)
* compatibility with new figure content blocker in latest Gutenberg version (CU-2x5j0cy)
* compatibility with wrong margin when embedding video in WP Bakery page builder (CU-2wu94qk)





## 0.3.2 (2022-08-29)


### chore

* introduce devowl-scripts binary (CU-2n41u7h)
* introduce for non-flat node_modules development experience (CU-2n41u7h)
* prepare packages for PNPM isolated module mode (CU-2n41u7h)


### refactor

* rename meta field forceHidden to shouldForceToShowVisual (CU-2d8dedh)
* rename meta field visual to isVisual (CU-2d8dedh)





## 0.3.1 (2022-08-09)


### fix

* compatibility with vanilla-lazyload used by WP Rocket Lazy Load plugin (CU-2pc568x)
* hijacking jQuery functions should keep static properties (CU-2tdff1g)
* visual content blocker got created for script even with force hidden deactivated (CU-2tdfe89)





# 0.3.0 (2022-07-06)


### feat

* allow to block content of custom elements (web components, CU-2nfkhc3)
* allow to memorize native events (CU-2p6az87)
* introduce new priorityClosed event (CU-2p6az87)


### fix

* compatibility with Avada Fusion Builder ratio class videos (CU-2nfkhc3)





## 0.2.6 (2022-06-13)


### fix

* compatibility with Podigee podcast player (CU-2kawh0f)





## 0.2.5 (2022-05-09)


### fix

* always execute scripts as last unblocked element (CU-2dkvyrh)





## 0.2.4 (2022-04-29)


### fix

* prettyPhoto is not available in MBStore theme as hijacked jQuery function does not call original (CU-2cwtg2e)





## 0.2.3 (2022-04-20)


### chore

* introduce predefined images for content blocker content types (CU-1y2d0mb)


### fix

* automatically scroll to unblocked, clicked element if not in viewport (CU-1zvkq2d)
* download thumbnail in standard format and force 16/9 ratio for YouTube videos (CU-eb4h2q)
* drill down visual thumbnail to nested blocked content when parent gets visual (CU-1z4fxer)
* introduce new options to be compatible with new consent-thumbnail integration (CU-eb4h2q)
* use setTimeout instead of instant visual painting (CU-eb4h2q)


### perf

* lazy load visual content blockers (CU-eb4h2q)
* lazy load visual content blockers in a more convenient way using idle callbacks (CU-eb4h2q)


### refactor

* create isomorphic-packages and frontend-packages (CU-22h231w)
* move more files to @devowl-wp/headless-content-unblocker
* revert empty commits for package folder rename (CU-22h231w)





## 0.2.2 (2022-04-04)

**Note:** This package (@devowl-wp/headless-content-unblocker) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.2.1 (2022-03-15)


### fix

* automatically play blocked video (HTML5 element, CU-206ybfu)
* force visual content blockers to be clickable through pointer-events (CU-1znu7xc)





# 0.2.0 (2022-03-01)


### feat

* allow to unblock style attributes with consent URLs (CU-1ydpqa1)


### fix

* allow chaining of overwritten jQuery ready function by giving context (CU-1yt6bjn)
* allow to wait for newly added synchronous scripts (CU-1z4m1fq)
* delegate click event to nested blocked items, too (CU-1z4gg3k)


### refactor

* detect last clicked to own file





## 0.1.2 (2022-02-11)


### fix

* compatibility with MyListing directory theme (CU-1y7v6cm)
* remove content blocker depending on consent checker instead of connected node (CU-1y25df6)





## 0.1.1 (2022-01-25)


### refactor

* extract unblocking mechanism to @devowl-wp/headless-content-unblocker (CU-23dqww5)
