const DYNAMICS_VARIABLE_REGEXP = /{{([A-Za-z0-9_]+)}}/gm;

/**
 * Takes any string and replaces `{{myVariable}}` with the value of the passed `dynamics` map.
 */
function applyDynamicsToHtml(src: string, dynamics: Record<string, string>) {
    return src.replace(DYNAMICS_VARIABLE_REGEXP, (fullMatch, variableName: string) =>
        Object.prototype.hasOwnProperty.call(dynamics, variableName) ? dynamics[variableName] : fullMatch,
    );
}

export { applyDynamicsToHtml, DYNAMICS_VARIABLE_REGEXP };
