import { INITIATOR_EXECUTION } from "../../events/initiatorExecution.js";

import type { InitiatorExecutionEvent } from "../../events/initiatorExecution.js";

const dispatchInitiatorExecution = <Details extends { type: string }>(detail: Details) => {
    document.dispatchEvent(
        new CustomEvent<InitiatorExecutionEvent<Details>>(INITIATOR_EXECUTION, {
            detail: {
                position: 0,
                ...detail,
            },
        }),
    );
    return () =>
        document.dispatchEvent(
            new CustomEvent<InitiatorExecutionEvent<Details>>(INITIATOR_EXECUTION, {
                detail: {
                    position: 1,
                    ...detail,
                },
            }),
        );
};

export { dispatchInitiatorExecution };
