/**
 * A custom initiator got executed.
 */
const INITIATOR_EXECUTION = "RCB/Initiator/Execution";

type InitiatorJQueryEventDetails = {
    type: "jQueryEvent";
    elem: HTMLElement;
    types: string[] | string;
    handler: any;
    data: any;
    selector: string;
};

type InitiatorJQueryReadyDetails = {
    type: "jQueryReady";
    fn: any;
};

type InitiatorNativeEventDetails = {
    type: "nativeEvent";
    eventName: string;
};

type InitiatorExecutionEvent<Details extends Record<string, any>> = {
    /**
     * 0 = Pre-execution
     * 1 = After-execution
     */
    position: 0 | 1;
    type: string;
} & Details;

export {
    INITIATOR_EXECUTION,
    type InitiatorJQueryEventDetails,
    type InitiatorJQueryReadyDetails,
    type InitiatorNativeEventDetails,
    type InitiatorExecutionEvent,
};
