import type { VisualConfiguration } from "../visual/createVisual.js";

/**
 * A content - which was blocked - got unblocked.
 */
export const OPT_IN_CONTENT_BLOCKER = "RCB/OptIn/ContentBlocker";

export type OptInContentBlockerEvent<ExtendedBlockerDefinition extends VisualConfiguration = VisualConfiguration> = {
    blocker: ExtendedBlockerDefinition;
    /**
     * This detail is only filled if you listen to the `document` event.
     */
    element?: HTMLElement;
    /**
     * If `true`, this element got unblocked due to the last click on the
     * "Unblock" button. This is useful e.g. to delegate the click event
     * further and start a video.
     */
    gotClicked: boolean;
};
