import type { findBlockedNodes } from "../checker/findBlockedNodes.js";

/**
 * A content - which was blocked - got unblocked. This event is **not** dispatched
 * for each unblocked content in a "transaction", instead it is dispatched
 * when the transaction is complete (all content got unblocked and loaded).
 */
export const OPT_IN_CONTENT_BLOCKER_ALL = "RCB/OptIn/ContentBlocker/All";

export type OptInContentBlockerAllEvent = {
    unblockedNodes: ReturnType<typeof findBlockedNodes>;
    /**
     * The `RCB/OptIn/ContentBlocker/All` does get fired after all synchronous elements are loaded, but
     * before all asynchrnous scripts (e.g. `<script async`) are loaded. This promise gets resolved when
     * all content is loaded.
     */
    load: Promise<void[]>;
};
