import { QuestionCircleFilled } from "@ant-design/icons";
import { Tag } from "antd";

import { useI18n } from "../../contexts/i18n.js";

import type { CSSProperties, FC } from "react";

const LearnMoreTag: FC<{ url: string; style?: CSSProperties; label?: string }> = ({
    url,
    style = undefined,
    label,
}) => {
    const { __ } = useI18n();
    const useStyle: CSSProperties = {
        cursor: "pointer",
        ...style,
    };

    return (
        <Tag style={useStyle} onClick={() => window.open(url, "_blank")}>
            <QuestionCircleFilled /> {label || __("Learn more")}
        </Tag>
    );
};

export { LearnMoreTag };
