import type { FC } from "react";

type NoticeEntry = { key?: string; message: any; severity?: "error" | "warning" | "info"; nop?: boolean };

const Notices: FC<{ notices: Array<NoticeEntry> }> = ({ notices }) => (
    <>
        {notices?.filter(Boolean).map(({ message, severity, nop, key }) =>
            message ? (
                severity ? (
                    <div
                        className={`notice notice-${severity} below-h2 notice-alt`}
                        key={key || message}
                        style={{ margin: "10px 0px 0px" }}
                    >
                        {typeof message === "string" ? (
                            message.startsWith("<p>") || nop ? (
                                <span dangerouslySetInnerHTML={{ __html: message }} />
                            ) : (
                                <p dangerouslySetInnerHTML={{ __html: message }} />
                            )
                        ) : nop ? (
                            message
                        ) : (
                            <p>{message}</p>
                        )}
                    </div>
                ) : (
                    message
                )
            ) : null,
        )}
    </>
);

export { Notices, type NoticeEntry };
