import { Modal, Result } from "antd";
import { useMemo } from "react";
import ReactRouterPrompt from "react-router-prompt";

import { useI18n } from "../../contexts/i18n.js";

import type { ComponentProps, FC } from "react";

const Prompt: FC<Pick<ComponentProps<typeof ReactRouterPrompt>, "when"> & { title: string }> = ({ when, title }) => {
    const { __ } = useI18n();
    const [useTitle, useSubtitle = ""] = useMemo(() => title.split(".").map((s) => `${s.trim()}.`), [title]);

    return (
        <ReactRouterPrompt when={when}>
            {({ isActive, onConfirm, onCancel }) => (
                <Modal
                    open={isActive}
                    onCancel={onCancel}
                    onOk={onConfirm}
                    centered
                    okText={__("Leave")}
                    cancelText={__("Cancel")}
                >
                    <Result status="warning" title={useTitle} subTitle={useSubtitle} />
                </Modal>
            )}
        </ReactRouterPrompt>
    );
};

export { Prompt };
