import { FormContentBlockerFieldGeneralDescription } from "./description.js";
import { FormContentBlockerFieldGeneralName } from "./name.js";
import { FormContentBlockerFieldGeneralStatus } from "./status.js";
import { useI18n } from "../../../../../contexts/i18n.js";
import { LearnMoreTag } from "../../../../common/learnMoreTag.js";
import { FormHeadline } from "../../../headline.js";
import { FormContentBlockerLayout } from "../../../layout.js";

import type { FC } from "react";

const FormContentBlockerFieldGeneralCompose: FC = () => {
    const { __ } = useI18n();

    return (
        <>
            <FormHeadline offset={FormContentBlockerLayout.labelCol.span}>
                {__("General content blocker configuration")}{" "}
                <LearnMoreTag
                    url={__("https://devowl.io/knowledge-base/real-cookie-banner-create-individual-content-blocker/")}
                />
            </FormHeadline>
            <FormContentBlockerFieldGeneralName />
            <FormContentBlockerFieldGeneralStatus />
            <FormContentBlockerFieldGeneralDescription />
        </>
    );
};

export { FormContentBlockerFieldGeneralCompose };
