import { Form, Input } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldGeneralDescription: FC = () => {
    const { __ } = useI18n();

    return (
        <Form.Item<FormContentBlockerValueProps> label={__("Description")}>
            <Form.Item<FormContentBlockerValueProps> name="description" noStyle>
                <Input.TextArea autoSize={{ minRows: 3 }} />
            </Form.Item>
            <p className="description">
                {__(
                    "You can give your visitors further explanations why a content has been blocked or, for example, how they can contact you alternatively instead of agreeing to load the contact form. The description is displayed only in visual content blockers.",
                )}
            </p>
        </Form.Item>
    );
};

export { FormContentBlockerFieldGeneralDescription };
