import { Form, Input } from "antd";
import { useState } from "react";

import { useI18n } from "../../../../../contexts/i18n.js";
import { FormValueDifferFromTemplateTag } from "../../../valueDifferFromTemplateTag.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldGeneralName: FC = () => {
    const { __ } = useI18n();
    const [ref, setRef] = useState<HTMLParagraphElement>();

    return (
        <Form.Item<FormContentBlockerValueProps> label={__("Name")} required>
            <Form.Item<FormContentBlockerValueProps>
                name="name"
                noStyle
                rules={[{ required: true, message: __("Please provide a name!") }]}
            >
                <Input />
            </Form.Item>
            <p className="description" ref={setRef}>
                <FormValueDifferFromTemplateTag
                    form="blocker"
                    valueName="name"
                    widthOfRef={ref}
                    renderDiff={(value) => <Input value={value} readOnly />}
                />
                {__(
                    'Each content blocker should have a descriptive name that is understandable to a non-professional user, e.g. "Google Maps".',
                )}
            </p>
        </Form.Item>
    );
};

export { FormContentBlockerFieldGeneralName };
