import { Form, Radio } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldGeneralStatus: FC = () => {
    const { __ } = useI18n();

    return (
        <Form.Item<FormContentBlockerValueProps> label={__("Status")} required>
            <Form.Item<FormContentBlockerValueProps>
                name="status"
                noStyle
                rules={[{ required: true, message: __("Please choose an option!") }]}
            >
                <Radio.Group>
                    <Radio.Button value="publish">{__("Enabled")}</Radio.Button>
                    <Radio.Button value="private">{__("Disabled")}</Radio.Button>
                    <Radio.Button value="draft">{__("Draft")}</Radio.Button>
                </Radio.Group>
            </Form.Item>
            <p className="description">
                {__(
                    'Content Blockers with the status "Draft" or "Disabled" are not visible to the public. In addition, a draft will be highlighted in the content blocker table so that you do not forget to configure it.',
                )}
            </p>
        </Form.Item>
    );
};

export { FormContentBlockerFieldGeneralStatus };
