import { Form } from "antd";

import { FormContentBlockerFieldTechnicalCriteria } from "./criteria.js";
import { FormContentBlockerFieldTechnicalRules } from "./rules.js";
import { FormContentBlockerFieldTechnicalServices } from "./services.js";
import { FormContentBlockerFieldTechnicalTcfVendors } from "./tcfVendors.js";
import { useFormContentBlocker } from "../../../../../contexts/formContentBlocker.js";
import { useI18n } from "../../../../../contexts/i18n.js";
import { Notices } from "../../../../common/notices.js";
import { FormHeadline } from "../../../headline.js";
import { FormContentBlockerLayout, FormServiceLayout } from "../../../layout.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { NoticeEntry } from "../../../../common/notices.js";
import type { ComponentProps, FC } from "react";

const FormContentBlockerFieldTechnicalCompose: FC<{
    servicesFieldProps: ComponentProps<typeof FormContentBlockerFieldTechnicalServices>;
    tcfVendorsFieldProps: ComponentProps<typeof FormContentBlockerFieldTechnicalTcfVendors>;
}> = ({ servicesFieldProps, tcfVendorsFieldProps }) => {
    const { __ } = useI18n();
    const { template } = useFormContentBlocker();

    const notices = (
        [
            {
                message: template?.ruleNotice,
                severity: "info",
            },
        ] as NoticeEntry[]
    )
        .filter(Boolean)
        .filter(({ message }) => message);

    return (
        <>
            <FormHeadline offset={FormContentBlockerLayout.labelCol.span}>{__("Technical Definition")}</FormHeadline>
            {notices.length > 0 && (
                <Form.Item
                    wrapperCol={{ offset: FormServiceLayout.labelCol.span, span: FormServiceLayout.wrapperCol.span }}
                    style={{ marginBottom: 0 }}
                >
                    <Notices notices={notices} />
                </Form.Item>
            )}
            <FormContentBlockerFieldTechnicalRules />
            <FormContentBlockerFieldTechnicalCriteria />
            <Form.Item<FormContentBlockerValueProps>
                noStyle
                shouldUpdate={(prevValues, nextValues) => prevValues.criteria !== nextValues.criteria}
            >
                {({ getFieldValue }) => {
                    switch (getFieldValue("criteria") as FormContentBlockerValueProps["criteria"]) {
                        case "services":
                            return <FormContentBlockerFieldTechnicalServices {...servicesFieldProps} />;
                        case "tcfVendors":
                            return <FormContentBlockerFieldTechnicalTcfVendors {...tcfVendorsFieldProps} />;
                        default:
                            return null;
                    }
                }}
            </Form.Item>
        </>
    );
};

export { FormContentBlockerFieldTechnicalCompose };
