import { Form, Radio } from "antd";

import { useFormContentBlocker } from "../../../../../contexts/formContentBlocker.js";
import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldTechnicalCriteria: FC = () => {
    const { __ } = useI18n();
    const { isTcf } = useFormContentBlocker();

    return (
        <Form.Item<FormContentBlockerValueProps>
            label={__("Block by")}
            required
            style={{ display: isTcf ? undefined : "none" }}
        >
            <Form.Item<FormContentBlockerValueProps>
                name="criteria"
                noStyle
                rules={[{ required: true, message: __("Please choose an option!") }]}
            >
                <Radio.Group>
                    <Radio.Button value="services">{__("Services")}</Radio.Button>
                    <Radio.Button value="tcfVendors">{__("TCF Vendors")}</Radio.Button>
                </Radio.Group>
            </Form.Item>
            <p className="description">
                {__(
                    "You can block content through non-standard services or TCF vendors. If you want to block it through TCF vendors, then the visual content blocker cannot be displayed because TCF is usually used to obtain consent for ad networks. Moreover, after the initial consents in the cookie banner, users will probably never consent to the ad.",
                )}
            </p>
        </Form.Item>
    );
};

export { FormContentBlockerFieldTechnicalCriteria };
