import { Form } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC, PropsWithChildren, ReactNode } from "react";

const FormContentBlockerFieldTechnicalServices: FC<PropsWithChildren<{ dropdown: ReactNode }>> = ({
    dropdown,
    children,
}) => {
    const { __, _i } = useI18n();

    return (
        <Form.Item<FormContentBlockerValueProps>
            noStyle
            shouldUpdate={(prevValues, nextValues) => prevValues.criteria !== nextValues.criteria}
        >
            {({ getFieldValue }) => {
                const criteria = getFieldValue("criteria") as FormContentBlockerValueProps["criteria"];

                return (
                    criteria === "services" && (
                        <Form.Item<FormContentBlockerValueProps> label={__("Connected services")} required>
                            <Form.Item<FormContentBlockerValueProps>
                                name="services"
                                noStyle
                                rules={[
                                    {
                                        type: "array",
                                        required: true,
                                        message: __("Please provide at least one service!"),
                                    },
                                ]}
                            >
                                {dropdown}
                            </Form.Item>
                            <p className="description">
                                {_i(
                                    __(
                                        "A content blocker is displayed until the user has agreed to {{strong}}all{{/strong}} necessary services that would be used by loading the content. You must define all services that are loaded as soon as the user wants to see the blocked content.",
                                    ),
                                    {
                                        strong: <strong />,
                                    },
                                )}
                            </p>
                            {children}
                        </Form.Item>
                    )
                );
            }}
        </Form.Item>
    );
};

export { FormContentBlockerFieldTechnicalServices };
