import { Checkbox, Col, Form, Row } from "antd";

import { useFormContentBlocker } from "../../../../../contexts/formContentBlocker.js";
import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC, PropsWithChildren, ReactNode } from "react";

const FormContentBlockerFieldTechnicalTcfVendors: FC<
    PropsWithChildren<{
        dropdownVendors: ReactNode;
    }>
> = ({ dropdownVendors, children }) => {
    const { __, _i } = useI18n();
    const { tcfPurposes = [] } = useFormContentBlocker();

    return (
        <>
            <Form.Item<FormContentBlockerValueProps>
                noStyle
                shouldUpdate={(prevValues, nextValues) => prevValues.criteria !== nextValues.criteria}
            >
                {({ getFieldValue }) => {
                    const criteria = getFieldValue("criteria") as FormContentBlockerValueProps["criteria"];

                    return (
                        criteria === "tcfVendors" && (
                            <>
                                <Form.Item<FormContentBlockerValueProps> label={__("Connected TCF Vendors")} required>
                                    <Form.Item<FormContentBlockerValueProps>
                                        name="tcfVendors"
                                        noStyle
                                        rules={[
                                            {
                                                type: "array",
                                                required: true,
                                                message: __("Please provide at least one vendor!"),
                                            },
                                        ]}
                                    >
                                        {dropdownVendors}
                                    </Form.Item>
                                    <p className="description">
                                        {_i(
                                            __(
                                                "A content blocker is displayed until the user has agreed to {{strong}}all{{/strong}} necessary TCF vendors and purposes that would be used by loading the content. You must define all TCF vendors and purposes that are loaded based on legitimate interest or consent as soon as the user wants to see the blocked content.",
                                            ),
                                            {
                                                strong: <strong />,
                                            },
                                        )}
                                    </p>
                                    {children}
                                </Form.Item>
                                <Form.Item<FormContentBlockerValueProps> label={__("Required TCF purposes")} required>
                                    <Form.Item<FormContentBlockerValueProps>
                                        noStyle
                                        name="tcfPurposes"
                                        rules={[
                                            {
                                                type: "array",
                                                required: true,
                                                message: __("Please provide at least one purpose!"),
                                            },
                                        ]}
                                    >
                                        <Checkbox.Group style={{ marginTop: 6 }}>
                                            <Row>
                                                {tcfPurposes.map(({ name, id }) => (
                                                    <Col key={`purpose-${id}`} span={12}>
                                                        <Checkbox value={id}>{name}</Checkbox>
                                                    </Col>
                                                ))}
                                            </Row>
                                        </Checkbox.Group>
                                    </Form.Item>
                                    <p className="description" style={{ marginTop: 10 }}>
                                        {__(
                                            'Defined which purposes of all connected TCF vendors must be allowed (by consent or legitimate interest) for the content blocker to unblock the content. At a minimum, "Store and/or access information on a device" should be given if cookies or similar information are read/written. In terms of data economy according to the GDPR, you should specify further purposes if, for example, only personalized advertising is displayed and therefore unblocking without consent/legitimate interest to this purpose has no practical use.',
                                        )}
                                    </p>
                                </Form.Item>
                            </>
                        )
                    );
                }}
            </Form.Item>
        </>
    );
};

export { FormContentBlockerFieldTechnicalTcfVendors };
