import { Checkbox, Form } from "antd";

import { useFormContentBlocker } from "../../../../contexts/formContentBlocker.js";
import { useI18n } from "../../../../contexts/i18n.js";
import { LearnMoreTag } from "../../../common/learnMoreTag.js";

import type { FormContentBlockerValueProps } from "../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldTemplateCheck: FC = () => {
    const { __, _x } = useI18n();
    const { templateCheck, isTemplateUpdate } = useFormContentBlocker();

    return (
        !!(templateCheck || isTemplateUpdate) && (
            <Form.Item<FormContentBlockerValueProps>
                name="templateCheck"
                valuePropName="checked"
                required
                rules={[
                    {
                        type: "boolean",
                        required: true,
                        transform: (value) => value || undefined,
                        message: __("Please confirm that you have checked the content of the content blocker."),
                    },
                ]}
            >
                <Checkbox>
                    {_x(
                        "I have checked the information in the content blocker template myself for correctness and completeness and have added missing information or corrected information that does not fit my use case. I am aware that the manufacturer of Real Cookie Banner cannot take any liability in this respect.",
                        "legal-text",
                    )}{" "}
                    <LearnMoreTag
                        url={__("https://devowl.io/knowledge-base/is-real-cookie-banner-legally-compliant/")}
                    />
                </Checkbox>
            </Form.Item>
        )
    );
};

export { FormContentBlockerFieldTemplateCheck };
