import { Form } from "antd";

import { FormContentBlockerFieldIsVisual } from "./isVisual.js";
import { FormContentBlockerFieldIsVisualDarkMode } from "./isVisualDarkMode.js";
import { FormContentBlockerFieldShouldForceToShowVisual } from "./shouldForceToShowVisual.js";
import { FormContentBlockerFieldVisualBlur } from "./visualBlur.js";
import { FormContentBlockerFieldVisualContentType } from "./visualContentType.js";
import { FormContentBlockerFieldVisualDownloadThumbnail } from "./visualDownloadThumbnail.js";
import { FormContentBlockerFieldVisualHeroButtonText } from "./visualHeroButtonText.js";
import { FormContentBlockerFieldVisualMediaThumbnail } from "./visualMediaThumbnail.js";
import { FormContentBlockerFieldVisualType } from "./visualType.js";
import { useI18n } from "../../../../../contexts/i18n.js";
import { FormHeadline } from "../../../headline.js";
import { FormContentBlockerLayout } from "../../../layout.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC, ReactNode } from "react";

const FormContentBlockerFieldVisualCompose: FC<{ visualMediaThumbnailPicker: ReactNode }> = ({
    visualMediaThumbnailPicker,
}) => {
    const { __ } = useI18n();

    return (
        <Form.Item<FormContentBlockerValueProps>
            noStyle
            shouldUpdate={(prevValues, nextValues) => prevValues.criteria !== nextValues.criteria}
        >
            {({ getFieldValue }) => {
                const criteria = getFieldValue("criteria") as FormContentBlockerValueProps["criteria"];

                return (
                    criteria === "services" && (
                        <>
                            <FormHeadline
                                offset={FormContentBlockerLayout.labelCol.span}
                                description={__(
                                    "For each content blocker it can be defined if it should be visually visible. This means that if the user has not agreed to the respective services, a box with a button is displayed to adjust the privacy settings so that the actual content can be loaded. The design of the box is copied from the cookie banner.",
                                )}
                            >
                                {__("Visual")}
                            </FormHeadline>
                            <FormContentBlockerFieldIsVisual />
                            <FormContentBlockerFieldVisualType />
                            <FormContentBlockerFieldVisualContentType />
                            <FormContentBlockerFieldIsVisualDarkMode />
                            <FormContentBlockerFieldVisualDownloadThumbnail />
                            <FormContentBlockerFieldVisualMediaThumbnail>
                                {visualMediaThumbnailPicker}
                            </FormContentBlockerFieldVisualMediaThumbnail>
                            <FormContentBlockerFieldVisualBlur />
                            <FormContentBlockerFieldVisualHeroButtonText />
                            <FormContentBlockerFieldShouldForceToShowVisual />
                        </>
                    )
                );
            }}
        </Form.Item>
    );
};

export { FormContentBlockerFieldVisualCompose };
