import { Form, Switch } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";
import { FormContentBlockerLayout } from "../../../layout.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldIsVisual: FC = () => {
    const { __ } = useI18n();

    return (
        <Form.Item<FormContentBlockerValueProps> wrapperCol={{ offset: FormContentBlockerLayout.labelCol.span }}>
            <span>
                <Form.Item<FormContentBlockerValueProps> name="isVisual" valuePropName="checked" noStyle>
                    <Switch />
                </Form.Item>
                <span>&nbsp;&nbsp;{__("Show the visual content blocker, if possible")}</span>
            </span>
        </Form.Item>
    );
};

export { FormContentBlockerFieldIsVisual };
