import { Form, Switch } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";
import { useUpsell } from "../../../../../contexts/upsell.js";
import { FormContentBlockerLayout } from "../../../layout.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldIsVisualDarkMode: FC = () => {
    const { __ } = useI18n();
    const { isPro } = useUpsell();

    return (
        isPro && (
            <Form.Item<FormContentBlockerValueProps>
                noStyle
                shouldUpdate={(prevValues, nextValues) =>
                    prevValues.isVisual !== nextValues.isVisual || prevValues.visualType !== nextValues.visualType
                }
            >
                {({ getFieldValue }) => {
                    const isVisual = getFieldValue("isVisual") as FormContentBlockerValueProps["isVisual"];
                    const visualType = getFieldValue("visualType") as FormContentBlockerValueProps["visualType"];

                    return (
                        !!isVisual &&
                        visualType !== "default" && (
                            <Form.Item<FormContentBlockerValueProps>
                                wrapperCol={{ offset: FormContentBlockerLayout.labelCol.span }}
                            >
                                <span>
                                    <Form.Item<FormContentBlockerValueProps>
                                        name="isVisualDarkMode"
                                        valuePropName="checked"
                                        noStyle
                                    >
                                        <Switch />
                                    </Form.Item>
                                    &nbsp;&nbsp;
                                    {__("Enable dark mode")}
                                    <p className="description">
                                        {__(
                                            "As soon as no image is found for the content blocker, a default image is automatically used. You can also specify whether the image should be displayed light or dark.",
                                        )}
                                    </p>
                                </span>
                            </Form.Item>
                        )
                    );
                }}
            </Form.Item>
        )
    );
};

export { FormContentBlockerFieldIsVisualDarkMode };
