import { Form, Switch } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";
import { FormContentBlockerLayout } from "../../../layout.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldShouldForceToShowVisual: FC = () => {
    const { __ } = useI18n();

    return (
        <Form.Item<FormContentBlockerValueProps>
            noStyle
            shouldUpdate={(prevValues, nextValues) => prevValues.isVisual !== nextValues.isVisual}
        >
            {({ getFieldValue }) => {
                const isVisual = getFieldValue("isVisual") as FormContentBlockerValueProps["isVisual"];

                return (
                    !!isVisual && (
                        <Form.Item<FormContentBlockerValueProps>
                            wrapperCol={{ offset: FormContentBlockerLayout.labelCol.span }}
                        >
                            <span>
                                <Form.Item<FormContentBlockerValueProps>
                                    name="shouldForceToShowVisual"
                                    valuePropName="checked"
                                    noStyle
                                >
                                    <Switch />
                                </Form.Item>
                                &nbsp;&nbsp;
                                {__("Force visual content blocker for hidden elements")}
                                <p className="description">
                                    {__(
                                        "In rare cases, visual content blockers are not displayed because the main element of the blocked content is not visible either. Enable this option if this is the case and you want to force to display a content blocker for non-visible elements.",
                                    )}
                                </p>
                            </span>
                        </Form.Item>
                    )
                );
            }}
        </Form.Item>
    );
};

export { FormContentBlockerFieldShouldForceToShowVisual };
