import { Form, Slider } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";
import { useUpsell } from "../../../../../contexts/upsell.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldVisualBlur: FC = () => {
    const { __ } = useI18n();
    const { isPro } = useUpsell();

    return (
        isPro && (
            <Form.Item<FormContentBlockerValueProps>
                noStyle
                shouldUpdate={(prevValues, nextValues) =>
                    prevValues.isVisual !== nextValues.isVisual || prevValues.visualType !== nextValues.visualType
                }
            >
                {({ getFieldValue }) => {
                    const isVisual = getFieldValue("isVisual") as FormContentBlockerValueProps["isVisual"];
                    const visualType = getFieldValue("visualType") as FormContentBlockerValueProps["visualType"];

                    return (
                        !!isVisual &&
                        visualType !== "default" && (
                            <Form.Item<FormContentBlockerValueProps> label={__("Blur image")}>
                                <Form.Item name="visualBlur" noStyle>
                                    <Slider
                                        min={0}
                                        max={20}
                                        marks={{
                                            0: __("Disabled"),
                                            5: "5%",
                                            10: "10%",
                                            15: "15%",
                                            20: "20%",
                                        }}
                                        tooltip={{ open: false }}
                                        style={{ marginLeft: 40 }}
                                    />
                                </Form.Item>
                                <p className="description">
                                    {__(
                                        "You can apply an additional blur to the background image. This can be useful e.g. for blocked contact forms to show it only schematically.",
                                    )}
                                </p>
                            </Form.Item>
                        )
                    );
                }}
            </Form.Item>
        )
    );
};

export { FormContentBlockerFieldVisualBlur };
