import { Card, Form, Radio } from "antd";
import { useMemo } from "react";

import { useI18n } from "../../../../../contexts/i18n.js";
import { useUpsell } from "../../../../../contexts/upsell.js";
import { useUpsellModalVisualContentBlocker } from "../../../../../hooks/useUpsellModalVisualContentBlocker.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldVisualContentType: FC = () => {
    const { __ } = useI18n();
    const { isPro } = useUpsell();
    const { modal, tag } = useUpsellModalVisualContentBlocker();

    const visualContentTypeTitles = useMemo(
        () => ({
            map: __("Map"),
            "audio-player": __("Audio player"),
            "video-player": __("Video player"),
            "feed-text": __("Feed (text)"),
            "feed-video": __("Feed (image/video)"),
            generic: __("None of these"),
        }),
        [__],
    );

    return (
        <>
            {modal}
            <Form.Item<FormContentBlockerValueProps>
                noStyle
                shouldUpdate={(prevValues, nextValues) =>
                    prevValues.isVisualDarkMode !== nextValues.isVisualDarkMode ||
                    prevValues.isVisual !== nextValues.isVisual ||
                    prevValues.visualType !== nextValues.visualType
                }
            >
                {({ getFieldValue }) => {
                    const isVisual = getFieldValue("isVisual") as FormContentBlockerValueProps["isVisual"];
                    const visualType = getFieldValue("visualType") as FormContentBlockerValueProps["visualType"];

                    return (
                        !!isVisual &&
                        visualType !== "default" && (
                            <Form.Item<FormContentBlockerValueProps> label={__("Content type")} required extra={tag}>
                                <Form.Item<FormContentBlockerValueProps>
                                    name="visualContentType"
                                    rules={[
                                        {
                                            required: true,
                                            message: __("Please choose an option!"),
                                        },
                                    ]}
                                >
                                    <Radio.Group
                                        size="large"
                                        buttonStyle="solid"
                                        className="rcb-antd-radio-button-card"
                                    >
                                        {Object.keys(visualContentTypeTitles).map((type) => {
                                            const title =
                                                visualContentTypeTitles[type as keyof typeof visualContentTypeTitles];

                                            return (
                                                <Radio.Button value={type} key={type} disabled={!isPro}>
                                                    <Card
                                                        style={{ width: 240 }}
                                                        bordered={false}
                                                        size="small"
                                                        cover={
                                                            <>
                                                                <img
                                                                    style={{
                                                                        display: getFieldValue("isVisualDarkMode")
                                                                            ? "none"
                                                                            : undefined,
                                                                    }}
                                                                    src={`https://assets.devowl.io/in-app/wp-real-cookie-banner/visual-content-blocker-preview/${type}-light.png`}
                                                                />
                                                                <img
                                                                    style={{
                                                                        display: getFieldValue("isVisualDarkMode")
                                                                            ? undefined
                                                                            : "none",
                                                                    }}
                                                                    src={`https://assets.devowl.io/in-app/wp-real-cookie-banner/visual-content-blocker-preview/${type}-dark.png`}
                                                                />
                                                            </>
                                                        }
                                                    >
                                                        <Card.Meta title={title} />
                                                    </Card>
                                                </Radio.Button>
                                            );
                                        })}
                                    </Radio.Group>
                                </Form.Item>
                            </Form.Item>
                        )
                    );
                }}
            </Form.Item>
        </>
    );
};

export { FormContentBlockerFieldVisualContentType };
