import { Form, Popconfirm, Radio } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";
import { useUpsell } from "../../../../../contexts/upsell.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldVisualDownloadThumbnail: FC = () => {
    const { __ } = useI18n();
    const { isPro } = useUpsell();

    return (
        isPro && (
            <Form.Item<FormContentBlockerValueProps>
                noStyle
                shouldUpdate={(prevValues, nextValues) =>
                    prevValues.visualDownloadThumbnail !== nextValues.visualDownloadThumbnail ||
                    prevValues.isVisual !== nextValues.isVisual ||
                    prevValues.visualType !== nextValues.visualType
                }
            >
                {({ getFieldValue, setFieldsValue }) => {
                    const visualDownloadThumbnail = getFieldValue(
                        "visualDownloadThumbnail",
                    ) as FormContentBlockerValueProps["visualDownloadThumbnail"];
                    const isVisual = getFieldValue("isVisual") as FormContentBlockerValueProps["isVisual"];
                    const visualType = getFieldValue("visualType") as FormContentBlockerValueProps["visualType"];

                    return (
                        !!isVisual &&
                        visualType !== "default" && (
                            <>
                                <Form.Item<FormContentBlockerValueProps> label={__("Automatic preview image")}>
                                    <Form.Item<FormContentBlockerValueProps>
                                        noStyle
                                        name="visualDownloadThumbnail"
                                        required
                                        rules={[
                                            {
                                                required: true,
                                                type: "boolean",
                                                message: __("Please choose an option!"),
                                            },
                                        ]}
                                    >
                                        <Radio.Group
                                            style={{
                                                display: visualDownloadThumbnail ? undefined : "none",
                                            }}
                                        >
                                            <Radio.Button value={true}>
                                                {__("Download preview image and serve locally")}
                                            </Radio.Button>
                                            <Radio.Button value={false}>{__("Image from media library")}</Radio.Button>
                                        </Radio.Group>
                                    </Form.Item>
                                    {!visualDownloadThumbnail && (
                                        <Radio.Group value={visualDownloadThumbnail}>
                                            <Popconfirm
                                                title={__(
                                                    "I confirm that I have the required rights to embedded content and its thumbnails can be copied to my servers without e.g. copyright infringement.",
                                                )}
                                                cancelText={__("Cancel")}
                                                okText={__("Activate now")}
                                                overlayStyle={{ maxWidth: 450 }}
                                                onCancel={() =>
                                                    setFieldsValue({
                                                        visualDownloadThumbnail: false,
                                                    })
                                                }
                                                onConfirm={() =>
                                                    setFieldsValue({
                                                        visualDownloadThumbnail: true,
                                                    })
                                                }
                                                placement="bottomLeft"
                                            >
                                                <Radio.Button value={true}>
                                                    {__("Download preview image and serve locally")}
                                                </Radio.Button>
                                            </Popconfirm>
                                            <Radio.Button
                                                value={false}
                                                onClick={() =>
                                                    setFieldsValue({
                                                        visualDownloadThumbnail: false,
                                                    })
                                                }
                                            >
                                                {__("Image from media library")}
                                            </Radio.Button>
                                        </Radio.Group>
                                    )}
                                    <p className="description">
                                        {__(
                                            "If you block an external URL, this option will try to download an image for this URL using different mechanisms (oEmbed, OpenGraph, ...), saves it locally and use it as background image.",
                                        )}
                                    </p>
                                </Form.Item>
                            </>
                        )
                    );
                }}
            </Form.Item>
        )
    );
};

export { FormContentBlockerFieldVisualDownloadThumbnail };
