import { Form, Input } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";
import { useUpsell } from "../../../../../contexts/upsell.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC } from "react";

const FormContentBlockerFieldVisualHeroButtonText: FC = () => {
    const { __ } = useI18n();
    const { isPro } = useUpsell();

    return (
        isPro && (
            <Form.Item<FormContentBlockerValueProps>
                noStyle
                shouldUpdate={(prevValues, nextValues) =>
                    prevValues.isVisual !== nextValues.isVisual || prevValues.visualType !== nextValues.visualType
                }
            >
                {({ getFieldValue }) => {
                    const isVisual = getFieldValue("isVisual") as FormContentBlockerValueProps["isVisual"];
                    const visualType = getFieldValue("visualType") as FormContentBlockerValueProps["visualType"];

                    return (
                        !!isVisual &&
                        visualType !== "default" && (
                            <Form.Item<FormContentBlockerValueProps>
                                noStyle
                                shouldUpdate={(prevValues, nextValues) =>
                                    prevValues.visualContentType !== nextValues.visualContentType
                                }
                            >
                                {({ getFieldValue }) => {
                                    const visualContentType = getFieldValue(
                                        "visualContentType",
                                    ) as FormContentBlockerValueProps["visualContentType"];
                                    const visualType = getFieldValue(
                                        "visualType",
                                    ) as FormContentBlockerValueProps["visualType"];

                                    return (
                                        <Form.Item<FormContentBlockerValueProps>
                                            label={__("Button text")}
                                            style={{
                                                display:
                                                    ["audio-player", "video-player"].indexOf(visualContentType) > -1 ||
                                                    visualType !== "hero"
                                                        ? "none"
                                                        : undefined,
                                            }}
                                        >
                                            <Form.Item<FormContentBlockerValueProps>
                                                name="visualHeroButtonText"
                                                noStyle
                                            >
                                                <Input />
                                            </Form.Item>
                                            <p className="description">
                                                {__(
                                                    "If you specify a button text, a button with this text will be centered in the image and only when you click on this button the content blocker will be opened. Otherwise, clicking on the image itself will open the Content Blocker.",
                                                )}
                                            </p>
                                        </Form.Item>
                                    );
                                }}
                            </Form.Item>
                        )
                    );
                }}
            </Form.Item>
        )
    );
};

export { FormContentBlockerFieldVisualHeroButtonText };
