import { Form } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";
import { useUpsell } from "../../../../../contexts/upsell.js";

import type { FormContentBlockerValueProps } from "../../../../../types/formContentBlocker.js";
import type { FC, PropsWithChildren } from "react";

const FormContentBlockerFieldVisualMediaThumbnail: FC<PropsWithChildren> = ({ children }) => {
    const { __ } = useI18n();
    const { isPro } = useUpsell();

    return (
        isPro && (
            <Form.Item<FormContentBlockerValueProps>
                noStyle
                shouldUpdate={(prevValues, nextValues) =>
                    prevValues.visualDownloadThumbnail !== nextValues.visualDownloadThumbnail ||
                    prevValues.isVisual !== nextValues.isVisual ||
                    prevValues.visualType !== nextValues.visualType ||
                    prevValues.visualContentType !== nextValues.visualContentType
                }
            >
                {({ getFieldValue }) => {
                    const isVisual = getFieldValue("isVisual") as FormContentBlockerValueProps["isVisual"];
                    const visualType = getFieldValue("visualType") as FormContentBlockerValueProps["visualType"];
                    const visualContentType = getFieldValue(
                        "visualContentType",
                    ) as FormContentBlockerValueProps["visualContentType"];
                    const visualDownloadThumbnail = getFieldValue(
                        "visualDownloadThumbnail",
                    ) as FormContentBlockerValueProps["visualDownloadThumbnail"];

                    return (
                        !!isVisual &&
                        visualType !== "default" && (
                            <Form.Item<FormContentBlockerValueProps>
                                label={
                                    visualDownloadThumbnail || visualContentType === "generic"
                                        ? __("Fallback preview image")
                                        : __("Preview image")
                                }
                                name="visualMediaThumbnail"
                                valuePropName="attachmentId"
                                style={{
                                    display: visualDownloadThumbnail === undefined ? "none" : undefined,
                                }}
                            >
                                {children}
                            </Form.Item>
                        )
                    );
                }}
            </Form.Item>
        )
    );
};

export { FormContentBlockerFieldVisualMediaThumbnail };
