import { Form } from "antd";
import { useRef } from "react";

import { FormFieldTemplateSuccessorDeletionCheck } from "../successorDeletionCheck.js";
import { FormUntranslatedTemplateNotice } from "../untranslatedTemplateNotice.js";
import { FormValueDifferFromTemplateNotice } from "../valueDifferFromTemplateNotice.js";
import { FormContentBlockerFieldGeneralCompose } from "./fields/general/compose.js";
import { FormContentBlockerFieldTechnicalCompose } from "./fields/technical/compose.js";
import { FormContentBlockerFieldTemplateCheck } from "./fields/templateCheck.js";
import { FormContentBlockerFieldVisualCompose } from "./fields/visual/compose.js";
import { useI18n } from "../../../contexts/i18n.js";
import {
    FORM_DIFFER_RESET_BUTTON_WITH_CONFIRM_CUSTOM_EVENT,
    FormValueDifferFromTemplateResetButtonWithConfirm,
} from "../valueDifferFromTemplateResetButtonWithConfirm.js";

import type { ComponentProps, FC } from "react";

const FormContentBlocker: FC<{
    technicalProps: ComponentProps<typeof FormContentBlockerFieldTechnicalCompose>;
    visualProps: ComponentProps<typeof FormContentBlockerFieldVisualCompose>;
}> = ({ technicalProps, visualProps }) => {
    const { __ } = useI18n();

    const ref = useRef();
    const refResetTemplateButton = useRef<HTMLAnchorElement>();

    return (
        <div ref={ref}>
            <FormValueDifferFromTemplateNotice
                containerRef={ref}
                resetButton={refResetTemplateButton}
                resetButtonEvent={FORM_DIFFER_RESET_BUTTON_WITH_CONFIRM_CUSTOM_EVENT}
                form="blocker"
            />
            <FormUntranslatedTemplateNotice form="blocker" />
            <FormContentBlockerFieldGeneralCompose />
            <FormContentBlockerFieldTechnicalCompose {...technicalProps} />
            <FormContentBlockerFieldVisualCompose {...visualProps} />
            <FormFieldTemplateSuccessorDeletionCheck type="blocker" />
            <Form.Item
                className="rcb-antd-form-sticky-submit"
                colon={false}
                labelAlign="left"
                label={<FormValueDifferFromTemplateResetButtonWithConfirm anchorRef={refResetTemplateButton} />}
            >
                <FormContentBlockerFieldTemplateCheck />
                <div style={{ textAlign: "center", margin: "10px 0" }}>
                    <input type="submit" className="button button-primary" value={__("Save")} />
                </div>
            </Form.Item>
        </div>
    );
};

export { FormContentBlocker };
