import { Flex, Form } from "antd";

import type { ComponentProps, FC, PropsWithChildren, ReactNode } from "react";

const FormHeadline: FC<
    PropsWithChildren<{
        description?: ReactNode;
        headlineExtra?: ReactNode;
        extra?: ReactNode;
        offset: ComponentProps<typeof Form>["wrapperCol"]["offset"];
    }>
> = ({ children, description, headlineExtra, extra, offset }) => (
    <Form.Item wrapperCol={{ offset }} style={{ borderBottom: "1px solid #e7e7e7" }}>
        <Flex justify="space-between" align="top">
            <h3 style={{ margin: `0 0 ${description ? 3 : 15}px 0` }}>{children}</h3>
            {headlineExtra}
        </Flex>
        {!!description && (
            <p className="description" style={{ marginBottom: 15 }}>
                {description}
            </p>
        )}
        {extra}
    </Form.Item>
);

export { FormHeadline };
