import { Checkbox, Form, Select } from "antd";

import { useFormService } from "../../../../contexts/formService.js";
import { useI18n } from "../../../../contexts/i18n.js";
import { Notices } from "../../../common/notices.js";
import { FormServiceLayout } from "../../layout.js";

import type { FormServiceValueProps } from "../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldCreateContentBlocker: FC = () => {
    const { __ } = useI18n();
    const { template, isEdit, essentialGroupId, allowContentBlockerCreation, contentBlockerTemplates } =
        useFormService();

    return (
        allowContentBlockerCreation &&
        !isEdit &&
        contentBlockerTemplates?.length > 0 && (
            <Form.Item<FormServiceValueProps> wrapperCol={{ offset: FormServiceLayout.labelCol.span }}>
                <Form.Item<FormServiceValueProps>
                    noStyle
                    shouldUpdate={(prevValues, nextValues) => prevValues.group !== nextValues.group}
                >
                    {({ getFieldValue }) => (
                        <Form.Item<FormServiceValueProps>
                            noStyle
                            name="createContentBlocker"
                            valuePropName="checked"
                            dependencies={["group"]}
                            rules={[
                                {
                                    validator: (_, value: boolean) =>
                                        getFieldValue("group") === essentialGroupId && value
                                            ? Promise.reject(
                                                  __(
                                                      'Services that should be associated with a content blocker cannot be in the "Essential" group, because it cannot be rejected.',
                                                  ),
                                              )
                                            : Promise.resolve(),
                                },
                            ]}
                        >
                            <Checkbox>{__("Create content blocker for this service.")}</Checkbox>
                        </Form.Item>
                    )}
                </Form.Item>
                <Form.Item<FormServiceValueProps>
                    noStyle
                    shouldUpdate={(prevValues, nextValues) =>
                        prevValues.createContentBlocker !== nextValues.createContentBlocker
                    }
                >
                    {({ getFieldValue }) => (
                        <>
                            {getFieldValue("createContentBlocker") && (
                                <>
                                    {contentBlockerTemplates.length > 1 && (
                                        <Form.Item
                                            noStyle
                                            name="createContentBlockerId"
                                            rules={[
                                                {
                                                    required: true,
                                                    message: __("Please select a template for the Content Blocker!"),
                                                },
                                            ]}
                                        >
                                            <Select
                                                style={{
                                                    maxWidth: 500,
                                                    marginTop: 10,
                                                    display: "block",
                                                }}
                                                placeholder={__("Select Content Blocker template...")}
                                            >
                                                {contentBlockerTemplates.map(({ identifier, name, subHeadline }) => (
                                                    <Select.Option key={identifier} value={identifier}>
                                                        {`${name}${
                                                            subHeadline && name.indexOf(subHeadline) === -1
                                                                ? ` (${subHeadline})`
                                                                : ""
                                                        }`}
                                                    </Select.Option>
                                                ))}
                                            </Select>
                                        </Form.Item>
                                    )}
                                </>
                            )}
                            <Notices
                                notices={[
                                    {
                                        message: getFieldValue("createContentBlocker")
                                            ? __(
                                                  "Immediately after submitting this form you will be forwarded to another form that allows you to create the Content Blocker.",
                                              )
                                            : undefined,
                                        severity: "info",
                                    },
                                    {
                                        message: template?.createContentBlockerNotice,
                                        severity: "info",
                                    },
                                ]}
                            />
                        </>
                    )}
                </Form.Item>
            </Form.Item>
        )
    );
};

export { FormServiceFieldCreateContentBlocker };
