import { FormServiceFieldGeneralDataProcessingCountries } from "./dataProcessingInCountries.js";
import { FormServiceFieldGeneralDataProcessingCountriesSpecialTreatment } from "./dataProcessingInCountriesSpecialTreatment.js";
import { FormServiceFieldGeneralGroup } from "./group.js";
import { FormServiceFieldGeneralLegalBasis } from "./legalBasis.js";
import { FormServiceFieldGeneralName } from "./name.js";
import { FormServiceFieldGeneralProvider } from "./provider.js";
import { FormServiceFieldGeneralProviderContact } from "./providerContact.js";
import { FormServiceFieldGeneralProviderLegalNoticeUrl } from "./providerLegalNoticeUrl.js";
import { FormServiceFieldGeneralProviderPrivacyPolicyUrl } from "./providerPrivacyPolicyUrl.js";
import { FormServiceFieldGeneralPurpose } from "./purpose.js";
import { FormServiceFieldGeneralStatus } from "./status.js";
import { useI18n } from "../../../../../contexts/i18n.js";
import { LearnMoreTag } from "../../../../common/learnMoreTag.js";
import { FormHeadline } from "../../../headline.js";
import { FormServiceLayout } from "../../../layout.js";

import type { FC } from "react";

const FormServiceFieldGeneralCompose: FC = () => {
    const { __ } = useI18n();

    return (
        <>
            <FormHeadline offset={FormServiceLayout.labelCol.span}>
                {__("General service configuration")}{" "}
                <LearnMoreTag
                    url={__("https://devowl.io/knowledge-base/real-cookie-banner-create-individual-cookie/")}
                />
            </FormHeadline>
            <FormServiceFieldGeneralName />
            <FormServiceFieldGeneralStatus />
            <FormServiceFieldGeneralGroup />
            <FormServiceFieldGeneralProvider />
            <FormServiceFieldGeneralProviderContact />
            <FormServiceFieldGeneralPurpose />
            <FormServiceFieldGeneralProviderPrivacyPolicyUrl />
            <FormServiceFieldGeneralProviderLegalNoticeUrl />
            <FormServiceFieldGeneralLegalBasis />
            <FormServiceFieldGeneralDataProcessingCountries />
            <FormServiceFieldGeneralDataProcessingCountriesSpecialTreatment />
        </>
    );
};

export { FormServiceFieldGeneralCompose };
