import { Form, Switch } from "antd";
import { useState } from "react";

import { useI18n } from "../../../../../contexts/i18n.js";
import { FormServiceLayout } from "../../../layout.js";
import { FormValueDifferFromTemplateTag } from "../../../valueDifferFromTemplateTag.js";

import type { FormServiceValueProps } from "../../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldGeneralIsEmbeddingOnlyExternalResources: FC = () => {
    const { __ } = useI18n();
    const [ref, setRef] = useState<HTMLDivElement>();

    const isEmbeddingOnlyExternalResourcesLabel = __(
        "This service does not set any technical cookies on the client of the visitor, but e.g. integrates a script.",
    );

    return (
        <Form.Item<FormServiceValueProps>
            required
            wrapperCol={{
                offset: FormServiceLayout.labelCol.span,
                span: FormServiceLayout.wrapperCol.span,
            }}
        >
            <Form.Item name="isEmbeddingOnlyExternalResources" valuePropName="checked" noStyle>
                <Switch />
            </Form.Item>
            <span>&nbsp;&nbsp;{isEmbeddingOnlyExternalResourcesLabel}</span>
            <div style={{ marginTop: 10 }} ref={setRef}>
                <FormValueDifferFromTemplateTag
                    form="service"
                    valueName="isEmbeddingOnlyExternalResources"
                    widthOfRef={ref}
                    renderDiff={(value) => (
                        <>
                            <Switch disabled checked={value} />
                            <span>
                                &nbsp;&nbsp;
                                {isEmbeddingOnlyExternalResourcesLabel}
                            </span>
                        </>
                    )}
                    noBr
                />
            </div>
        </Form.Item>
    );
};

export { FormServiceFieldGeneralIsEmbeddingOnlyExternalResources };
