import { Col, Form, Input, Row } from "antd";
import { useState } from "react";

import { useI18n } from "../../../../../contexts/i18n.js";
import { FormValueDifferFromTemplateTag, diffByJsonStringify } from "../../../valueDifferFromTemplateTag.js";

import type { FormServiceValueProps } from "../../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldGeneralProviderContact: FC = () => {
    const { __ } = useI18n();
    const [ref, setRef] = useState<HTMLDivElement>();

    return (
        <Form.Item<FormServiceValueProps>
            noStyle
            shouldUpdate={(prevValues, nextValues) =>
                prevValues.isProviderCurrentWebsite !== nextValues.isProviderCurrentWebsite
            }
        >
            {({ getFieldValue }) => (
                <Form.Item<FormServiceValueProps>
                    label={__("Provider contact")}
                    style={{ display: getFieldValue("isProviderCurrentWebsite") ? "none" : undefined }}
                >
                    <div ref={setRef}>
                        <Row gutter={[10, 10]}>
                            <Col span={12}>
                                <Form.Item<FormServiceValueProps>
                                    name={["providerContact", "phone"]}
                                    style={{ margin: 0 }}
                                >
                                    <Input addonBefore={__("Phone")} />
                                </Form.Item>
                            </Col>
                            <Col span={12}>
                                <Form.Item<FormServiceValueProps>
                                    name={["providerContact", "email"]}
                                    rules={[{ type: "email", message: __("Please provide a valid email!") }]}
                                    style={{ margin: 0 }}
                                >
                                    <Input addonBefore={__("Email")} />
                                </Form.Item>
                            </Col>
                            <Col span={24}>
                                <Form.Item<FormServiceValueProps>
                                    name={["providerContact", "link"]}
                                    rules={[{ type: "url", message: __("Please provide a valid URL!") }]}
                                    style={{ margin: 0 }}
                                >
                                    <Input addonBefore={__("Contact form")} />
                                </Form.Item>
                            </Col>
                        </Row>
                        <FormValueDifferFromTemplateTag
                            form="service"
                            valueName="providerContact"
                            widthOfRef={ref}
                            style={{ marginTop: 3 }}
                            difference={diffByJsonStringify}
                            ignoreEmptyDefaultValue
                            renderDiff={({ email, phone, link }) => (
                                <Row gutter={[10, 10]}>
                                    <Col span={12}>
                                        <Input addonBefore={__("Phone")} value={phone} readOnly />
                                    </Col>
                                    <Col span={12}>
                                        <Input addonBefore={__("Email")} value={email} readOnly />
                                    </Col>
                                    <Col span={24}>
                                        <Input addonBefore={__("Contact form")} value={link} readOnly />
                                    </Col>
                                </Row>
                            )}
                        />
                    </div>
                </Form.Item>
            )}
        </Form.Item>
    );
};

export { FormServiceFieldGeneralProviderContact };
