import { Form, Input } from "antd";
import { useState } from "react";

import { useI18n } from "../../../../../contexts/i18n.js";
import { FormValueDifferFromTemplateTag } from "../../../valueDifferFromTemplateTag.js";

import type { FormServiceValueProps } from "../../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldGeneralProviderLegalNoticeUrl: FC = () => {
    const { __ } = useI18n();
    const [ref, setRef] = useState<HTMLParagraphElement>();

    return (
        <Form.Item<FormServiceValueProps>
            noStyle
            shouldUpdate={(prevValues, nextValues) =>
                prevValues.isProviderCurrentWebsite !== nextValues.isProviderCurrentWebsite
            }
        >
            {({ getFieldValue }) => (
                <Form.Item<FormServiceValueProps>
                    label={__("Legal notice of the provider")}
                    style={{ display: getFieldValue("isProviderCurrentWebsite") ? "none" : undefined }}
                >
                    <Form.Item<FormServiceValueProps>
                        name="providerLegalNoticeUrl"
                        noStyle
                        rules={[{ type: "url", message: __("Please provide a valid URL!") }]}
                    >
                        <Input />
                    </Form.Item>
                    <p className="description" ref={setRef}>
                        <FormValueDifferFromTemplateTag
                            form="service"
                            valueName="providerLegalNoticeUrl"
                            widthOfRef={ref}
                            ignoreEmptyDefaultValue
                            renderDiff={(value) => <Input value={value} readOnly />}
                        />
                        {__(
                            "Provide a direct link to the legal notice or contact of the provider who operates this service (in the language of your website).",
                        )}
                    </p>
                </Form.Item>
            )}
        </Form.Item>
    );
};

export { FormServiceFieldGeneralProviderLegalNoticeUrl };
