import { Form, Input } from "antd";
import { useState } from "react";

import { useI18n } from "../../../../../contexts/i18n.js";
import { FormValueDifferFromTemplateTag } from "../../../valueDifferFromTemplateTag.js";

import type { FormServiceValueProps } from "../../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldGeneralProviderPrivacyPolicyUrl: FC = () => {
    const { __ } = useI18n();
    const [ref, setRef] = useState<HTMLParagraphElement>();

    return (
        <Form.Item<FormServiceValueProps>
            noStyle
            shouldUpdate={(prevValues, nextValues) =>
                prevValues.isProviderCurrentWebsite !== nextValues.isProviderCurrentWebsite
            }
        >
            {({ getFieldValue }) => (
                <Form.Item<FormServiceValueProps>
                    label={__("Privacy policy of the provider")}
                    required
                    style={{ display: getFieldValue("isProviderCurrentWebsite") ? "none" : undefined }}
                >
                    <Form.Item<FormServiceValueProps>
                        name="providerPrivacyPolicyUrl"
                        noStyle
                        rules={[
                            {
                                required: !getFieldValue("isProviderCurrentWebsite"),
                                type: "url",
                                message: __("Please provide a valid URL!"),
                            },
                        ]}
                    >
                        <Input />
                    </Form.Item>
                    <p className="description" ref={setRef}>
                        <FormValueDifferFromTemplateTag
                            form="service"
                            valueName="providerPrivacyPolicyUrl"
                            widthOfRef={ref}
                            renderDiff={(value) => <Input value={value} readOnly />}
                        />
                        {__(
                            "Provide a direct link to the privacy policy of the provider that runs this service (in the language of your website).",
                        )}
                    </p>
                </Form.Item>
            )}
        </Form.Item>
    );
};

export { FormServiceFieldGeneralProviderPrivacyPolicyUrl };
