import { Form, Input } from "antd";
import { useState } from "react";

import { useI18n } from "../../../../../contexts/i18n.js";
import { FormValueDifferFromTemplateTag } from "../../../valueDifferFromTemplateTag.js";

import type { FormServiceValueProps } from "../../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldGeneralPurpose: FC = () => {
    const { __ } = useI18n();
    const [ref, setRef] = useState<HTMLParagraphElement>();

    return (
        <Form.Item<FormServiceValueProps> label={__("Purpose")}>
            <Form.Item<FormServiceValueProps> name="purpose" noStyle>
                <Input.TextArea autoSize={{ minRows: 3 }} />
            </Form.Item>
            <p className="description" ref={setRef}>
                <FormValueDifferFromTemplateTag form="service" valueName="purpose" widthOfRef={ref} />
                {__(
                    "The ePrivacy Directive and the GDPR require that a non-professional user understands the purpose of this service, how personal data is collected and how cookies are used for this purpose.",
                )}
            </p>
        </Form.Item>
    );
};

export { FormServiceFieldGeneralPurpose };
