import { Form } from "antd";
import { useState } from "react";

import { FormServiceFieldHandlingSkipIfActiveNotice } from "./skipIfActiveNotice.js";
import { useFormService } from "../../../../../contexts/formService.js";
import { useI18n } from "../../../../../contexts/i18n.js";
import { FormValueDifferFromTemplateTag } from "../../../valueDifferFromTemplateTag.js";

import type { FormServiceValueProps } from "../../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldHandlingCodeOnPageLoad: FC = () => {
    const { __ } = useI18n();
    const { renderCodeMirror } = useFormService();
    const [ref, setRef] = useState<HTMLDivElement>();

    return (
        <Form.Item<FormServiceValueProps> label={__("Code executed on page load")}>
            <Form.Item name="codeOnPageLoad" noStyle>
                {renderCodeMirror()}
            </Form.Item>
            <FormServiceFieldHandlingSkipIfActiveNotice name="codeOnPageLoad" />
            <div ref={setRef}>
                <FormValueDifferFromTemplateTag
                    style={{ marginTop: 10 }}
                    form="service"
                    valueName="codeOnPageLoad"
                    widthOfRef={ref}
                    noBr
                    splitView={false}
                />
            </div>
        </Form.Item>
    );
};

export { FormServiceFieldHandlingCodeOnPageLoad };
