import { Form, Switch } from "antd";
import { useState } from "react";

import { useI18n } from "../../../../../contexts/i18n.js";
import { FormServiceLayout } from "../../../layout.js";
import { FormValueDifferFromTemplateTag } from "../../../valueDifferFromTemplateTag.js";

import type { FormServiceValueProps } from "../../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldHandlingDeleteTechnicalDefinitionsAfterOptOut: FC = () => {
    const { __ } = useI18n();
    const [ref, setRef] = useState<HTMLDivElement>();

    const deleteTechnicalDefinitionsAfterOptOutLabel = __(
        "Delete all first-party cookies after opt-out. First-party cookies are only cookies that are set by or for this domain.",
    );

    return (
        <Form.Item<FormServiceValueProps>
            noStyle
            shouldUpdate={(prevValues, nextValues) =>
                prevValues.isEmbeddingOnlyExternalResources !== nextValues.isEmbeddingOnlyExternalResources
            }
        >
            {({ getFieldValue }) =>
                getFieldValue("isEmbeddingOnlyExternalResources") ? null : (
                    <Form.Item<FormServiceValueProps>
                        required
                        wrapperCol={{
                            offset: FormServiceLayout.labelCol.span,
                            span: FormServiceLayout.wrapperCol.span,
                        }}
                    >
                        <Form.Item<FormServiceValueProps>
                            name="deleteTechnicalDefinitionsAfterOptOut"
                            valuePropName="checked"
                            noStyle
                        >
                            <Switch />
                        </Form.Item>
                        <span>&nbsp;&nbsp;{deleteTechnicalDefinitionsAfterOptOutLabel}</span>
                        <div style={{ marginTop: 10 }} ref={setRef}>
                            <FormValueDifferFromTemplateTag
                                form="service"
                                valueName="deleteTechnicalDefinitionsAfterOptOut"
                                widthOfRef={ref}
                                renderDiff={(value) => (
                                    <>
                                        <Switch disabled checked={value} />
                                        <span>
                                            &nbsp;&nbsp;
                                            {deleteTechnicalDefinitionsAfterOptOutLabel}
                                        </span>
                                    </>
                                )}
                                noBr
                            />
                        </div>
                    </Form.Item>
                )
            }
        </Form.Item>
    );
};

export { FormServiceFieldHandlingDeleteTechnicalDefinitionsAfterOptOut };
